
(* Creates a new autoloading zone *)
FUNCTION_BLOCK PMC_AutoLoadingZone_Create
	PMC_CmdProcessor(Execute, 0,FALSE, PM_Controller, PMCFuncInfo, Done,DummyDone, Busy, Error, ErrorID, Aborted);

	IF PMCFuncInfo.SendToPMC THEN
		CASE PMCFuncInfo.MsgPartNStatus OF
			1:  (* Statement section case 1*)
				(*SendToPMCDataRegion//*)
				(*Sending Command to PMC*)
				(* read current heart beat of field bus*)
				memcpy(pDest := ADR(cmdHB),pSrc := PM_Controller.P2H_START + PM_Controller.PMC_Constants.P2H_CMDC_OFFSET,length := 1);
				(*update command heart beat*)
				cmdHB := cmdHB + 1;
				cmdHB := cmdHB AND 255;
				(*--------------write command info*)
				(*command ID*)
				memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_CMDID_OFFSET,pSrc := ADR(cmdID),length := 2);
				(*Mode:*)
				memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_DATA_OFFSET + 3,pSrc := ADR(Mode),length := 1);
				(*Zone ID: *)
				memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_DATA_OFFSET + 4,pSrc := ADR(ZoneID),length := 1);
				(*Zone Mode: *)
				memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_DATA_OFFSET + 5,pSrc := ADR(ZoneMode),length := 1);
				(*Unloading Mode:*)
				memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_DATA_OFFSET + 6,pSrc := ADR(UnloadingMode),length := 1);
				(*Zone Center X*)
				memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_DATA_OFFSET + 7,pSrc := ADR(ZoneCenterX),length := 4);
				(*Zone Center Y*)
				memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_DATA_OFFSET + 11,pSrc := ADR(ZoneCenterY),length := 4);
				(*Zone length*)
				memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_DATA_OFFSET + 15,pSrc := ADR(ZoneLength),length := 4);
				(*Zone width*)
				memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_DATA_OFFSET + 19,pSrc := ADR(ZoneWidth),length := 4);
				(*max xbot size X*)
				memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_DATA_OFFSET + 23,pSrc := ADR(MaxXbotSizeX),length := 4);
				(*max xbot size Y*)
				memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_DATA_OFFSET + 27,pSrc := ADR(MaxXbotSizeY),length := 4);
				(*max zone speed*)
				memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_DATA_OFFSET + 31,pSrc := ADR(MaxVel),length := 4);
				(*max zone accel*)
				memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_DATA_OFFSET + 35,pSrc := ADR(MaxAcc),length := 4);
				(*write command heart beat*)
				memcpy(pDest := PM_Controller.H2P_START + PM_Controller.PMC_Constants.H2P_CMDC_OFFSET,pSrc := ADR(cmdHB),length := 1);
				(*SendToPMCDataRegionEnd//*)
				PMCFuncInfo.MsgPartNStatus := 0;   (*finished sending, report all done*)
			ELSE  (* Statement section ELSE*)
				PMCFuncInfo.MsgPartNStatus := -2;   (*error detected, invalid part*)
		END_CASE;
	END_IF;

	IF PMCFuncInfo.ReadFromPMC THEN
		CASE PMCFuncInfo.MsgPartNStatus OF
			1:
				(*ReadFromPMCDataRegion//*)
				(*ReadFromPMCDataRegionEnd//*)
				PMCFuncInfo.MsgPartNStatus := 0; (*0 = all parts finished reading*)
			ELSE
				PMCFuncInfo.MsgPartNStatus := -2;   (*wrong part number*)
		END_CASE;
	END_IF;

	IF PMCFuncInfo.SendToPMC OR PMCFuncInfo.ReadFromPMC THEN
		PMC_CmdProcessor(Execute, 1,FALSE, PM_Controller, PMCFuncInfo, Done,DummyDone, Busy, Error, ErrorID, Aborted);
	END_IF;

	(*timeout check, overrides the cmdprocessor outputs in case it has implementation errors. Hard timeout check*)
	IF Execute = TRUE AND Busy = TRUE THEN
		timeout := timeout + 1;
		IF timeout > PM_Controller.PMC_Constants.PMC_TIMEOUT THEN
			ErrorID := 8201;    (*timeout error id*)
			Error := TRUE;
			Busy := FALSE;
			Aborted := FALSE;
			Done := FALSE;
			(*the command processor will close the ticket,*)
			PMCFuncInfo.CmdSta := 30; (*idle state, and not change any outputs such as ErrorID or Eroor*)
			PMC_CmdProcessor(Execute, 2,FALSE, PM_Controller, PMCFuncInfo, Done,DummyDone, Busy, Error, ErrorID, Aborted);
		END_IF;
	ELSE
		timeout := 0;
	END_IF;
END_FUNCTION_BLOCK
